#!/bin/bash
#SBATCH --time=20:00:00
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=10
#SBATCH --mem=400000

#Make directory for alignment results and stats
mkdir ./ALIGNMENT

#Load variables
. variables

#define variables
genomeDir=/scratch/cmp1g20/ref_genome/hg38_index/

#load modules
module load gcc/11.1.0
module load STAR/2.7.10a

#run STAR alignment
STAR --genomeDir $genomeDir \
--runThreadN 16 \
--readFilesIn "$read1" "$read2" \
--readFilesCommand zcat \
--outSAMtype BAM SortedByCoordinate \
--quantMode GeneCounts \
--outFileNamePrefix "$sampleID"_ \
--outSAMattributes Standard \
--limitBAMsortRAM 907614101000

